local function PlayerArea( pn )
	local iLeftAtStart = GAMESTATE:GetNumStagesLeft(pn);

	local t = Def.ActorFrame { 
		Name=pn;
	};
	t[#t+1] = LoadFont("Common Normal") .. {
		InitCommand=cmd(y,0;NoStroke;shadowlength,0);
		RefreshCommand=function(self)
			if iLeftAtStart > 0 then
				self:settext("KEEP GOING!");
			else
				self:settext("READY");
			end
		end;
	--	ShowCommand=cmd(diffusealpha,0;zoom,2;linear,0.2;zoom,1;diffusealpha,1);				
	};

	return t;
end

local t = Def.ActorFrame {
	InitCommand=cmd(playcommand,"Refresh";);
	RefreshCommand=function(self) 			
			for p in ivalues(PlayerNumber) do
				local enabled = GAMESTATE:IsPlayerEnabled(p);
				self:GetChild(p):visible( enabled );
			end
		end;
	PlayerJoinedMessageCommand=cmd(playcommand,"Refresh");
	PlayerUnjoinedMessageCommand=cmd(playcommand,"Refresh");
	CurrentStyleChangedMessageCommand=cmd(playcommand,"Refresh");
	CoinInsertedMessageCommand=cmd(playcommand,"Refresh");
	CoinModeChangedMessageCommand=cmd(playcommand,"Refresh");
};

t[#t+1] = PlayerArea( "PlayerNumber_P1" ) .. {
	InitCommand=cmd(x,SCREEN_CENTER_X-180;y,SCREEN_CENTER_Y;);
};
t[#t+1] = PlayerArea( "PlayerNumber_P2" ) .. {
	InitCommand=cmd(x,SCREEN_CENTER_X+180;y,SCREEN_CENTER_Y;);
};

t[#t+1] = LoadActor( THEME:GetPathS(Var "LoadingScreen", "hurry timer") ) .. {
	HurryTimerMessageCommand=cmd(play);
};
t[#t+1] = LoadActor( THEME:GetPathS(Var "LoadingScreen", "out keep going") ) .. {
	Precache=false;
	OffCommand=function(self) 
		if GAMESTATE:GetNumPlayersEnabled() ~= 0 then
			self:play();
		end
	end;
};
-- played by SSM, which is always preloaded here
--[[t[#t+1] = LoadActor( THEME:GetPathS("", "_player joined") ) .. {
	Precache=false;
	PlayerJoinedMessageCommand=cmd(play);
}; ]]

return t;
